import iris
import plot_functions as pf
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.font_manager import FontProperties
import pylab
import datetime as dt
import cartopy.crs as ccrs
import regions
import copy
import iris.coord_categorisation as icc

iimelt_mask = iris.load_cube('/data/local/hadax/PhD/Attribution/output_v4_06_09_2018/output_3D/HadGEM2_ES/Hist1/monthly/hadgom/iimelt.std_ISCCP.1997.nc').data.mask


model = 'HadGEM2_ES'
experiments = ['Hist' + str(em) for em in range(1,5)]
startyear = 1980
endyear = 1999
region_name = 'Arctic_Ocean.0'
version = 'v4_06_09_2018'
processes = ['SW_down','LW_down','Ice_area','Ice_thickness','iimelt']
obs_scheme = 'std_CERES'

outfile = '/home/h01/hadax/graphics/PhD/Papers/Dec2013_HadGEM2_energy_budget/'+\
    'v2.3_figs/Figures/F7_annual_total_cpts.eps'

basedir = '/data/local/hadax/PhD/Attribution/'
datadirs = [basedir + 'output_'+version + '/output_3D/' + \
    model + '/' + expt + '/monthly/hadgom/' for expt in experiments]
cubedic = {}
for process in processes:
    rcubelist = iris.cube.CubeList([])
    for (iexpt,datadir) in enumerate(datadirs):
        ycubelist = iris.cube.CubeList([])
        for year in range(startyear,endyear+1):
            ffile = datadir + process + '.' + obs_scheme + '.' + \
                    str(year) + '.nc'
            ccube = iris.load_cube(ffile)
            ycubelist.append(ccube)

        ycubes = ycubelist.concatenate()
        if len(ycubes) > 1:
            print 'Could not concatenate year cubes'
            raise ValueError
        ycube = ycubes[0]
        icc.add_month(ycube,'time')
        sc_cube = ycube.aggregated_by(['month'],iris.analysis.MEAN)
        rcoord = iris.coords.AuxCoord(iexpt+1,'realization')
        sc_cube.add_aux_coord(rcoord)
        rcubelist.append(sc_cube)

    rcubes = rcubelist.merge()
    if len(rcubes) > 1:
        print 'Could not merge realization cubes'
        raise ValueError

    rcube = rcubes[0]
    mean_cube = rcube.collapsed(['realization'],iris.analysis.MEAN)
    regions.reduce_to_region(mean_cube,region_name,'hadgom')

    if process == 'iimelt':
        index = np.where(iimelt_mask)
        mean_cube.data.mask[index] = True
    cubedic[process] = mean_cube

cubedic_t = {process: cubedic[process].collapsed(['time'],\
    iris.analysis.MEAN) for process in processes}

total_cube = copy.deepcopy(cubedic_t['SW_down'])
total_cube.data[:] = 0.
for process in processes:
    total_cube = total_cube + cubedic_t[process]

regions.reduce_to_region(total_cube,region_name,'hadgom')

nps = ccrs.NorthPolarStereo()
xl = .04
yb = .69
xw = .4
yw = .3
xs = .5
ys = .31

xl_cb = .2
yb_cb = .05
xw_cb = .6
yw_cb = .015

levels = np.arange(-15,16,3)
cmap = plt.get_cmap('RdBu_r')

figure = plt.figure(figsize=(6,9))
for (iproc,process) in enumerate(processes):
    xi = iproc % 2
    yi = iproc / 2
    
    axis = figure.add_axes([xl+xs*xi,yb-ys*yi,xw,yw],projection=nps)
    clev = pf.polarplot(cubedic_t[process],figure=figure,axis=axis,\
                      levels=levels,cmap=cmap,show=False,colorbar=False,\
                      title = process,rrange=3.e6)

axis = figure.add_axes([xl+xs*1,yb-ys*2,xw,yw],projection=nps)
clev = pf.polarplot(total_cube,figure=figure,axis=axis,\
                      levels=levels,cmap=cmap,show=False,colorbar=False,\
                      title = 'TOTAL',rrange=3.e6)

ax_cl = figure.add_axes([xl_cb,yb_cb,xw_cb,yw_cb])
plt.colorbar(clev,cax=ax_cl,orientation='horizontal')
ax_cl.text(.5,-2.5,'ISF bias ($Wm^{-2}$)',ha='center')

pylab.savefig(outfile)
