import sys
import numpy as np
import matplotlib.pyplot as plt
import regrid
import cartopy.crs as ccrs
import pylab
import iris
import plot_functions as pf
import copy
from matplotlib.font_manager import FontProperties

font_large = FontProperties(size=16)

startyear = 1980
endyear = 1999
model = 'HadGEM2_ES'
experiments = ['Hist' + str(expti) for expti in range(1,5)]
temp_cutoff = 273.15-1.

outfile_eps = '/home/h01/hadax/graphics/PhD/Papers/Dec2013_HadGEM2_energy_budget/'+\
    'v3.1/Figures/F4_melt_onset.eps'
outfile_png = '/home/h01/hadax/graphics/PhD/Papers/Dec2013_HadGEM2_energy_budget/'+\
    'v3.1/Figures/F4_melt_onset.png'
sys.path.insert(0,'/home/h01/hadax/Python/PhD/Obs/')
sys.path.insert(0,'/home/h01/hadax/Python/PhD/Buoys/hadax-IceMassBalanceBuoys/')

import melt_onset
import buoys

cube = melt_onset.read3(startyear=startyear,endyear=endyear)
cube_on_hadgom = regrid.regrid2(cube,'n96',out_region='Arctic_Ocean.0')
cube_pmean = cube_on_hadgom[0:20,:,:].collapsed(['time'],iris.analysis.MEAN)
tcode = str(startyear) + '.' + str(endyear)

varname = 'Melt onset from Tsfc >= '+str(temp_cutoff)
model_cubelist = iris.cube.CubeList([])
for (iexpt,expt) in enumerate(experiments):
    melt_onset_file = '/data/local/hadax/PhD/'+model+'/'+expt+'/melt_onset/'+\
        'melt_onset_from_Tsfc.' + tcode + '.nc'
    melt_onset_cube = iris.load_cube(melt_onset_file,varname)
    rcoord = iris.coords.AuxCoord(iexpt+1,'realization')
    melt_onset_cube.add_aux_coord(rcoord)
    model_cubelist.append(melt_onset_cube)

model_cubes = model_cubelist.merge()
if len(model_cubes) > 1:
    print 'Could not merge model cubes'
    raise ValueError

model_cube = model_cubes[0]
model_mean_cube = model_cube.collapsed(['realization','time'],iris.analysis.MEAN)

obs_cube_cfg = copy.deepcopy(model_mean_cube)
obs_cube_cfg.data = cube_pmean.data
anomaly_cube = model_mean_cube - obs_cube_cfg

xl = .04
yb = .16
xw = .26
yw = .8
xs = .33
ym_cb = .05
yw_cb = .03
plot_cubes = [model_mean_cube,obs_cube_cfg,anomaly_cube]
titles = ['(a)','(b)','(c)']
cb_labels = ['Melt onset day of year (HadGEM2-ES)','Melt onset day of year (SSMI)',\
    'Model bias (days)']

cmap_abs = plt.get_cmap('YlGnBu')
cmap_diff = plt.get_cmap('RdBu')

levels_abs = np.arange(120,180,5)
levels_diff = np.arange(-20,21,5)

cmaps = [cmap_abs,cmap_abs,cmap_diff]
levelss = [levels_abs,levels_abs,levels_diff]

nps = ccrs.NorthPolarStereo()
figure = plt.figure(figsize=(14,5))

for (icube,cube) in enumerate(plot_cubes):
    ax = figure.add_axes([xl+xs*icube,yb,xw,yw],projection=nps)
    clev = pf.polarplot(cube,axis=ax,figure=figure,show=False,colorbar=False,\
         cmap= cmaps[icube],levels=levelss[icube],rrange=3.e6)
    
    ax.set_title(titles[icube],fontproperties=font_large)
    
    ax_cb = figure.add_axes([xl+xs*icube,yb-yw_cb,xw,yw_cb])
    plt.colorbar(clev,cax=ax_cb,orientation='horizontal')
    for label in ax_cb.get_xticklabels():
        label.set_fontproperties(font_large)
    ax_cb.text(.5,-3.5,cb_labels[icube],ha='center',fontproperties=font_large)

pylab.savefig(outfile_eps)
pylab.savefig(outfile_png)
